/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import com.ibm.hwmca.fw.log.DumpAttributes;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.log.RestartAttributes;
import com.ibm.hwmca.fw.log.TraceAttributes;

public class FrameworkLogAttributes
extends LogAttributes
implements TraceAttributes,
RestartAttributes,
DumpAttributes {
    public static final boolean FULL_TRACE = true;
    public static final boolean OMIT_FULL_TRACE = false;
    public static final boolean PROCESS_TRACE = true;
    public static final boolean OMIT_PROCESS_TRACE = false;
    public static final boolean THREAD_TRACE = true;
    public static final boolean OMIT_THREAD_TRACE = false;
    public static final boolean JVM_DUMP = true;
    public static final boolean NO_JVM_DUMP = false;
    public static final byte RESTART_APP = 2;
    public static final byte RESTART_SYS = 1;
    public static final byte NO_RESTART = 0;
    public static final FrameworkLogAttributes ERROR_LOG = new FrameworkLogAttributes(true, false, true, true, true, true, false, 0);
    public static final FrameworkLogAttributes INFO_LOG = new FrameworkLogAttributes(false, false, false, true, true, true, false, 0);
    public static final FrameworkLogAttributes ERROR_LOG_NO_TRACE = new FrameworkLogAttributes(true, false, true, false, false, false, false, 0);
    public static final FrameworkLogAttributes INFO_LOG_NO_TRACE = new FrameworkLogAttributes(false, false, false, false, false, false, false, 0);
    public static final FrameworkLogAttributes ERROR_LOG_RESTART = new FrameworkLogAttributes(true, false, true, true, true, true, true, 2);
    public static final FrameworkLogAttributes ERROR_LOG_RESTART_SYS = new FrameworkLogAttributes(true, false, true, true, true, true, true, 1);
    public static final FrameworkLogAttributes DEFAULT = ERROR_LOG;
    private static final short RESTART_ATTR = 256;
    private static final short RESTART_APP_ATTR = 4096;
    private static final short OMIT_FULL_TRACE_ATTR = 512;
    private static final short OMIT_PROCESS_TRACE_ATTR = 1024;
    private static final short OMIT_THREAD_TRACE_ATTR = 2048;
    private static final short JVM_DUMP_ATTR = 8192;

    public FrameworkLogAttributes(boolean error, boolean modifyLogBlock, boolean displayAsError, boolean fullTrace, boolean processTrace, boolean threadTrace, boolean jvmDump, byte restart) {
        super(error, true, modifyLogBlock, displayAsError);
        if (!fullTrace) {
            this.attribs_ = (short)(this.attribs_ | 0x200);
        }
        if (!processTrace) {
            this.attribs_ = (short)(this.attribs_ | 0x400);
        }
        if (!threadTrace) {
            this.attribs_ = (short)(this.attribs_ | 0x800);
        }
        if (jvmDump) {
            this.attribs_ = (short)(this.attribs_ | 0x2000);
        }
        if (restart == 2) {
            this.attribs_ = (short)(this.attribs_ | 0x1000);
        } else if (restart == 1) {
            this.attribs_ = (short)(this.attribs_ | 0x100);
        }
    }

    public FrameworkLogAttributes(boolean error) {
        this(error, false, error, true, true, true, false, 0);
    }

    public FrameworkLogAttributes() {
        this(true, false, true, true, true, true, false, 0);
    }

    public boolean isFullTrace() {
        return (this.attribs_ & 0x200) == 0;
    }

    public boolean isProcessTrace() {
        return (this.attribs_ & 0x400) == 0;
    }

    public boolean isThreadTrace() {
        return (this.attribs_ & 0x800) == 0;
    }

    public boolean isJvmDump() {
        return (this.attribs_ & 0x2000) != 0;
    }

    public boolean isApplicationRestart() {
        return (this.attribs_ & 0x1000) != 0;
    }

    public boolean isSystemRestart() {
        return (this.attribs_ & 0x100) != 0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("@").append(this.hashCode()).append(this.isError() ? "[Error," : "[Info,").append(this.isStandardBlock() ? "Std," : "~Std,").append(this.isModifyBlock() ? "Mod," : "~Mod,").append(this.isDisplayAsError() ? "Err," : "~Err,").append(this.isFullTrace() ? "FTrc," : "~FTrc,").append(this.isProcessTrace() ? "PTrc," : "~PTrc,").append(this.isThreadTrace() ? "TTrc," : "~TTrc,").append(this.isJvmDump() ? "Dmp," : "~Dmp,").append(this.isApplicationRestart() ? "RsrtApp]" : (this.isSystemRestart() ? "RsrtSys]" : "~Rsrt]"));
        return result.toString();
    }
}

